const BASE = "https://steelliongames.com";
const iframe = document.getElementById("webview");
const homeBtn = document.getElementById("home");
const popoutBtn = document.getElementById("popout");
const closeBtn = document.getElementById("close");

console.log("popup.js loaded");

homeBtn.addEventListener("click", () => {
  iframe.src = BASE;
});

closeBtn.addEventListener("click", () => {
  window.close();
});

popoutBtn.addEventListener("click", () => {
  const popoutUrl = chrome.runtime.getURL("popout.html") + "?src=" + encodeURIComponent(iframe.src || BASE);
  chrome.windows.create({
    url: popoutUrl,
    type: "popup",
    width: 1000,
    height: 800
  });
});
