// popout.js
const DEFAULT = "https://steelliongames.com";
const iframe = document.getElementById("popFrame");
const homeBtn = document.getElementById("home");
const closeBtn = document.getElementById("close");

console.log("popout.js loaded");

// read src query param
const params = new URLSearchParams(location.search);
let startSrc = params.get("src") || DEFAULT;

// set iframe to the passed-in source (decoded)
try {
  startSrc = decodeURIComponent(startSrc);
} catch(e){ /* ignore */ }
iframe.src = startSrc;
console.log("popout iframe src:", iframe.src);

// home button resets to site home
homeBtn.addEventListener("click", () => {
  console.log("popout home clicked");
  iframe.src = DEFAULT;
});

// close window
closeBtn.addEventListener("click", () => {
  console.log("popout close clicked");
  window.close();
});
